/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search.similarities;

import java.util.Collections;
import org.apache.lucene.ars_nouveau.index.FieldInvertState;
import org.apache.lucene.ars_nouveau.index.IndexOptions;
import org.apache.lucene.ars_nouveau.search.CollectionStatistics;
import org.apache.lucene.ars_nouveau.search.Explanation;
import org.apache.lucene.ars_nouveau.search.TermStatistics;
import org.apache.lucene.ars_nouveau.util.SmallFloat;

public abstract class Similarity {
    private final boolean discountOverlaps;

    public final boolean getDiscountOverlaps() {
        return this.discountOverlaps;
    }

    protected Similarity() {
        this(true);
    }

    protected Similarity(boolean discountOverlaps) {
        this.discountOverlaps = discountOverlaps;
    }

    public long computeNorm(FieldInvertState state) {
        int numTerms = state.getIndexOptions() == IndexOptions.DOCS ? state.getUniqueTermCount() : (this.discountOverlaps ? state.getLength() - state.getNumOverlap() : state.getLength());
        return SmallFloat.intToByte4(numTerms);
    }

    public abstract SimScorer scorer(float var1, CollectionStatistics var2, TermStatistics ... var3);

    public static abstract class SimScorer {
        protected SimScorer() {
        }

        public abstract float score(float var1, long var2);

        public Explanation explain(Explanation freq, long norm) {
            return Explanation.match((Number)Float.valueOf(this.score(freq.getValue().floatValue(), norm)), "score(freq=" + String.valueOf(freq.getValue()) + "), with freq of:", Collections.singleton(freq));
        }
    }
}

